
binAdjustPformPD <- function(dataf){
  PTMscore <- dataf
  
  PTMscore$Peptide_mod <- paste0(PTMscore$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PTMscore$Modifications))))
  
  PTMscore$Peptidoform <- paste0( PTMscore$Peptide_mod,"_", PTMscore$PTM_Positions)
  
  PTMscore$PROTEIN_LOC <- str_replace_all(paste0(PTMscore$Protein,"_",PTMscore$PRO_Position), " ", "")
  
  PTM2<- PTMscore %>% group_by(PROTEIN_LOC) %>% dplyr::mutate(count_S = n())
  
  
  
  # Number of different possibilities to be observed N #
  
  PTM3 <- FFreqPD(PTM2)
  
  PTM3$Spectrum <- PTM3$Unique_scan
  
  PTM3$Mods2 <- as.character(gsub('[0-9]+', '', PTM3$Modifications))
  
  PTM3$SpectA<- as.character(gregexpr(pattern ='A\\(Phospho',PTM3$Mods2))
  
  PTM3$Num_As <-ifelse( PTM3$SpectA=='-1',0,1)
  
  PTM2Unique <- PTM3 %>% dplyr::arrange(Spectrum) %>% distinct(Spectrum, .keep_all = TRUE) %>% ungroup()
  
  
  
  PTM3$probChance3 <- sum(PTM2Unique$Num_As)/length(PTM2Unique$Spectrum)
  
  
  # Calculation of binomial prob #
  
  
  PTM3$bioprob3 <- dbinom(PTM3$count_S, PTM3$N_Count, PTM3$probChance3)
  
  # Combine as independent p1*(1-P2) #
  
  
  PTM3$Bin_Adjusted_Score <- (1-PTM3$bioprob3)*PTM3$PTM_Final_prob
  
  
  BinomialSet3 <- PTM3 %>% group_by(Peptidoform) %>% top_n(1, Bin_Adjusted_Score)
  
  BinomialSet <- subset(BinomialSet3,select = c(Bin_Adjusted_Score,Peptidoform,Unique_scan))
  
  PTMscore$Unique_scan <- NULL
  
  total <- merge(PTMscore,BinomialSet,by="Peptidoform")
  
  
  ReducedTable2 <- total %>% dplyr::arrange(Peptidoform) %>% distinct(Peptidoform, .keep_all = TRUE) %>% ungroup()
  

return(ReducedTable2)
}